-- Tabele z pliku AgencjaArtystycznaStrukturaMY.sql muszą zostać utworzone najpierw.

USE AgencjaArtystycznaPrzyklad;

CREATE VIEW R04_lista_telefonow_agentow
AS 
SELECT NazwiskoAgenta, ImieAgenta, TelefonAgenta
FROM Agenci
ORDER BY NazwiskoAgenta, ImieAgenta;



CREATE VIEW R04_daty_imprez
AS 
SELECT DISTINCT DzienRozpoczecia
FROM Imprezy;



CREATE VIEW R04_informacje_o_imprezach
AS 
SELECT Imprezy.*
FROM Imprezy;



CREATE VIEW R04_siedziby_wykonawcow
AS 
SELECT MiastoWykonawcy, NazwaScenicznaWykonawcy
FROM Wykonawcy
ORDER BY MiastoWykonawcy, NazwaScenicznaWykonawcy;



CREATE VIEW R04_zaplanowane_imprezy
AS 
SELECT DzienRozpoczecia, NumerImprezy
FROM Imprezy
ORDER BY DzienRozpoczecia DESC , NumerImprezy;



CREATE VIEW R05_klienci_wedlug_miasta
AS 
SELECT MiastoKlienta AS Miasto, Concat(NazwiskoKlienta, ', ', ImieKlienta) AS Klient
FROM Klienci
ORDER BY Miasto, Klient;



CREATE VIEW R05_dlugosc_imprez
AS 
SELECT NumerImprezy, Concat((DateDiff(DzienZakonczenia, DzienRozpoczecia) + 1), ' dni (dzień)') AS CzasTrwania
FROM Imprezy;



CREATE VIEW R05_strony_www_wykonawcow
AS 
SELECT NazwaScenicznaWykonawcy AS Wykonawca, Concat('Strona WWW: ', StronaInterWykonawcy) AS Odwiedz
FROM Wykonawcy;



CREATE VIEW R05_pierwszy_sprawdzian_polroczny
AS 
SELECT Concat(NazwiskoAgenta, ', ', ImieAgenta) AS Agent, DataZatrudnienia, Date_Add(DataZatrudnienia, Interval 180 Day) AS PierwszySprawdzian
FROM Agenci
ORDER BY Agent;



CREATE VIEW R05_wartosc_netto_kontraktow
AS 
SELECT NumerImprezy, WartoscKontraktu, WartoscKontraktu * 0.12 AS NaszeHonorarium, WartoscKontraktu - (WartoscKontraktu * 0.12) AS WartoscNetto
FROM Imprezy;



CREATE VIEW R06_wykonawcy_z_trzech_miast
AS 
SELECT NazwaScenicznaWykonawcy, TelefonWykonawcy, MiastoWykonawcy
FROM Wykonawcy
WHERE MiastoWykonawcy In ('Bellevue', 'Redmond', 'Woodinville')
ORDER BY NazwaScenicznaWykonawcy;



CREATE VIEW R06_czterodniowe_imprezy
AS 
SELECT NumerImprezy, DzienRozpoczecia, DzienZakonczenia
FROM Imprezy
WHERE DateDiff(DzienZakonczenia, DzienRozpoczecia) = 3;



CREATE VIEW R06_imprezy_w_pazdzierniku_2017
AS 
SELECT NumerImprezy, WartoscKontraktu, DzienRozpoczecia, DzienZakonczenia
FROM Imprezy
WHERE DzienRozpoczecia <= CAST('2017-10-31' As DATE)
AND DzienZakonczenia >= CAST('2017-10-01' As DATE);



CREATE VIEW R06_imprezy_pazdziernikowe_miedzy_12_a_17
AS 
SELECT NumerImprezy, DzienRozpoczecia, GodzinaRozpoczecia
FROM Imprezy
WHERE DzienRozpoczecia <= CAST('2017-10-31' As DATE)
AND DzienZakonczenia >= CAST('2017-10-01' AS DATE)
AND GodzinaRozpoczecia Between CAST('12:00:00' AS TIME) AND CAST('17:00:00' AS TIME);


CREATE VIEW R06_imprezy_jednodniowe
AS 
SELECT NumerImprezy, DzienRozpoczecia, DzienZakonczenia
FROM Imprezy
WHERE DzienRozpoczecia = DzienZakonczenia;



CREATE VIEW R08_agenci_i_daty_imprez
AS 
SELECT Concat(Agenci.ImieAgenta, ' ', Agenci.NazwiskoAgenta) AS PersonaliaAgenta, Imprezy.DzienRozpoczecia
FROM Agenci
INNER JOIN Imprezy
ON Agenci.IDAgenta = Imprezy.IDAgenta
ORDER BY DzienRozpoczecia;



CREATE VIEW R08_agenci_i_wykonawcy_ten_sam_kod_pocztowy
AS 
SELECT Concat(Agenci.ImieAgenta, ' ', Agenci.NazwiskoAgenta) AS PersonaliaAgenta, Wykonawcy.NazwaScenicznaWykonawcy, Agenci.KodPocztowyAgenta
FROM Agenci
INNER JOIN Wykonawcy
ON Agenci.KodPocztowyAgenta = Wykonawcy.KodPocztowyWykonawcy;



CREATE VIEW R08_klienci_i_zamowione_przez_nich_wystepy
AS 
SELECT DISTINCT Concat(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS PersonaliaKlienta, Wykonawcy.NazwaScenicznaWykonawcy
FROM (Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta = Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy;



CREATE VIEW R08_wykonawcy_i_kontrakty
AS 
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia, Imprezy.WartoscKontraktu
FROM Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy;


CREATE VIEW R08_wykonawcy_wystepujacy_dla_Berga_I_Hallmark
AS 
SELECT EntBerg.NazwaScenicznaWykonawcy
FROM (SELECT DISTINCT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM (Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy)
INNER JOIN Klienci
ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE Klienci.NazwiskoKlienta = 'Berg') AS EntBerg
INNER JOIN (SELECT DISTINCT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM (Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy)
INNER JOIN Klienci
ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE Klienci.NazwiskoKlienta = 'Hallmark') AS EntHallmark
ON EntBerg.IDWykonawcy = EntHallmark.IDWykonawcy;


CREATE VIEW R08_wykonawcy_wystepujacy_dla_Berga_LUB_Hallmark
AS 
SELECT DISTINCT Wykonawcy.NazwaScenicznaWykonawcy
FROM (Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy)
INNER JOIN Klienci
ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE Klienci.NazwiskoKlienta = 'Berg'
OR Klienci.NazwiskoKlienta = 'Hallmark';


CREATE VIEW R09_agenci_bez_kontraktow
AS 
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta
FROM Agenci LEFT JOIN Imprezy
ON Agenci.IDAgenta = Imprezy.IDAgenta
WHERE Imprezy.NumerImprezy IS NULL;



CREATE VIEW R09_wszyscy_wykonawcy_dowolne_imprezy
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Imprezy.NumerImprezy, Imprezy.DzienRozpoczecia, Imprezy.IDKlienta
FROM Wykonawcy LEFT JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy;



CREATE VIEW R09_wszystkie_style_i_dowolni_klienci
AS 
SELECT Style_muzyczne.IDStylu, Style_muzyczne.NazwaStylu, Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Style_muzyczne LEFT JOIN (Gusty_muzyczne
INNER JOIN Klienci
ON Klienci.IDKlienta = Gusty_muzyczne.IDKlienta)
ON Style_muzyczne.IDStylu = Gusty_muzyczne.IDStylu;



CREATE VIEW R09_klienci_brak_rezerwacji
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci LEFT JOIN Imprezy
ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE Imprezy.NumerImprezy IS NULL;



CREATE VIEW R09_wykonawcy_nigdy_nie_zamawiani
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy LEFT JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
WHERE Imprezy.NumerImprezy Is Null;



CREATE VIEW R10_agenci_UNION_wykonawcy
AS 
SELECT Concat(Agenci.NazwiskoAgenta, ', ', Agenci.ImieAgenta) AS Personalia, 'Agent' AS Typ
FROM Agenci
UNION SELECT Wykonawcy.NazwaScenicznaWykonawcy, 'Wykonawca' AS Typ
FROM Wykonawcy;



CREATE VIEW R10_klienci_i_wykonawcy_muzyka_wspolczesna
AS 
SELECT Concat(Klienci.ImieKlienta, ' ', Klienci.NazwiskoKlienta) AS Personalia, 'Klient' AS Typ
FROM Style_muzyczne
INNER JOIN (Klienci
INNER JOIN Gusty_muzyczne
ON Klienci.IDKlienta = Gusty_muzyczne.IDKlienta)
ON Style_muzyczne.IDStylu = Gusty_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu='Współczesna'
UNION SELECT Wykonawcy.NazwaScenicznaWykonawcy, 'Wykonawca' AS Typ
FROM Style_muzyczne
INNER JOIN (Wykonawcy
INNER JOIN Style_wykonawcow
ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy)
ON Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu
WHERE Style_muzyczne.NazwaStylu='Współczesna';



CREATE VIEW R10_klienci_UNION_wykonawcy
AS 
SELECT Concat(Klienci.NazwiskoKlienta, ', ', Klienci.ImieKlienta) AS Personalia, 'Klient' AS Typ
FROM Klienci
UNION SELECT Wykonawcy.NazwaScenicznaWykonawcy AS Personalia, 'Wykonawca' AS Typ
FROM Wykonawcy;


CREATE VIEW R11_nieoperatywni_agenci
AS 
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta
FROM Agenci
WHERE Agenci.IDAgenta NOT IN 
(SELECT Imprezy.IDAgenta
 FROM Imprezy);
 
 
CREATE VIEW R11_ostatnia_rezerwacja_klientow
AS 
SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, (Select Max(DzienRozpoczecia) FROM Imprezy WHERE Imprezy.IDKlienta = Klienci.IDKlienta) AS OstatniaRezerwacja
FROM Klienci;



CREATE VIEW R11_klienci_ktorzy_lubia_muzyke_country
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM ((Style_muzyczne 
INNER JOIN Style_wykonawcow 
ON Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy)  
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy 
WHERE Style_muzyczne.NazwaStylu='Country'
OR Style_muzyczne.NazwaStylu='Country Rock');



CREATE VIEW R11_liczba_wystepow_wykonawcow
AS 
SELECT Wykonawcy.NazwaScenicznaWykonawcy, (SELECT COUNT(*) FROM Imprezy WHERE Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) AS LiczbaWystepow
FROM Wykonawcy;



CREATE VIEW R11_wykonawcy_dla_klienta_Berg_EXISTS
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE EXISTS 
(SELECT * FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Berg'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy);



CREATE VIEW R11_wykonawcy_dla_klienta_Berg_IN
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE IDWykonawcy IN 
(SELECT Imprezy.IDWykonawcy 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Berg');



CREATE VIEW R11_wykonawcy_dla_klientow_Berg_lub_Hallmark_SOME
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy = Some 
(SELECT Imprezy.IDWykonawcy 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Berg'
OR Klienci.NazwiskoKlienta='Hallmark');



CREATE VIEW R12_srednia_placa_agenta
AS 
SELECT AVG(Wynagrodzenie) AS SredniaPlacaAgenta
FROM Agenci;



CREATE VIEW R12_wartosc_kontraktu_wieksza_od_sredniej
AS 
SELECT Imprezy.NumerImprezy
FROM Imprezy
WHERE WartoscKontraktu >=(SELECT AVG(WartoscKontraktu) FROM Imprezy);



CREATE VIEW R12_najstarsze_imprezy
AS 
SELECT NumerImprezy, WartoscKontraktu
FROM Imprezy
WHERE DzienRozpoczecia =
   (SELECT MIN(DzienRozpoczecia) FROM Imprezy);



CREATE VIEW R12_najstarsze_imprezy_w_pazdzierniku
AS
SELECT Imprezy.NumerImprezy, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia, Imprezy.IDKlienta
FROM Imprezy
WHERE Imprezy.DzienRozpoczecia = 
   (SELECT MIN(DzienRozpoczecia) FROM Imprezy WHERE DzienRozpoczecia BETWEEN CAST('2017-10-01' AS DATE) AND CAST('2017-10-31' AS DATE));


   
CREATE VIEW R12_imprezy_drozsze_niz_suma_wrzesnia
AS
SELECT NumerImprezy, WartoscKontraktu
FROM Imprezy
WHERE WartoscKontraktu >
   (SELECT SUM(WartoscKontraktu) FROM Imprezy
     WHERE DzienRozpoczecia BETWEEN CAST('2017-09-01' AS Date)
     AND CAST('2017-09-30' AS Date));

	 

CREATE VIEW R12_liczba_wykonawcow_mieszkajacych_w_Bellevue
AS 
SELECT COUNT(*) AS LiczbaWykonawcow
FROM Wykonawcy
WHERE MiastoWykonawcy = 'Bellevue';



CREATE VIEW R12_laczna_wartosc_kontraktow_w_pazdzierniku_2017
AS 
SELECT SUM(WartoscKontraktu) AS TotalBookedValue
FROM Imprezy
WHERE DzienRozpoczecia BETWEEN CAST('2017-10-01' AS DATE)
AND CAST('2017-10-31' AS DATE);



CREATE VIEW R13_sumy_kontraktow_i_prowizje_agentow
AS 
SELECT Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Sum(Imprezy.WartoscKontraktu) AS SumaWartosciKontraktow, (Sum(WartoscKontraktu) * Premia) AS Prowizja
FROM Agenci
INNER JOIN Imprezy
ON Agenci.IDAgenta = Imprezy.IDAgenta
GROUP BY Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.Premia;



CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wszyscy_wykonawcy
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Count(Imprezy.IDWykonawcy) AS LiczbaKontraktow, 
Sum(Imprezy.WartoscKontraktu) AS WartOgolem, Min(Imprezy.WartoscKontraktu) AS CenaMin, 
Max(Imprezy.WartoscKontraktu) AS CenaMaks, Avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Wykonawcy 
LEFT JOIN Imprezy 
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;


CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wszyscy_wykonawcy_ZLE
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Count(*) AS LiczbaKontraktow, 
Sum(Imprezy.WartoscKontraktu) AS WartOgolem, Min(Imprezy.WartoscKontraktu) AS CenaMin, 
Max(Imprezy.WartoscKontraktu) AS CenaMaks, Avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Wykonawcy 
LEFT JOIN Imprezy 
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;


CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wg_klienta
AS 
SELECT Klienci.NazwiskoKlienta, Klienci.ImieKlienta, Count(*) AS LiczbaKontraktow, 
Sum(Imprezy.WartoscKontraktu) AS WartOgolem, Min(Imprezy.WartoscKontraktu) AS CenaMin, 
Max(Imprezy.WartoscKontraktu) AS CenaMaks, Avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta = Imprezy.IDKlienta
GROUP BY Klienci.NazwiskoKlienta, Klienci.ImieKlienta;


CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wg_wykonawcy
AS 
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Count(*) AS LiczbaKontraktow, 
Sum(Imprezy.WartoscKontraktu) AS WartOgolem, Min(Imprezy.WartoscKontraktu) AS CenaMin, 
Max(Imprezy.WartoscKontraktu) AS CenaMaks, Avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;


CREATE VIEW R13_kontrakt_stulecia
AS 
SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Imprezy.DzienRozpoczecia, Imprezy.WartoscKontraktu
FROM Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE Imprezy.WartoscKontraktu > All 
   (Select Sum(WartoscKontraktu) 
    From Imprezy As E2 
    Where E2.IDKlienta <> Klienci.IDKlienta 
    Group By E2.IDKlienta);


CREATE VIEW R13_najnowsze_kontrakty_klientow
AS 
SELECT Concat(Klienci.NazwiskoKlienta, ', ', Klienci.ImieKlienta) AS PersonaliaKlienta, Concat(Klienci.AdresKlienta, ', ', Klienci.MiastoKlienta, ', ', Klienci.StanZamKlienta, ' ', Klienci.KodPocztowyKlienta) AS PelnyAdresKlienta, Max(Imprezy.DzienRozpoczecia) AS OstatniaData, Sum(Imprezy.WartoscKontraktu) AS LacznaWartoscKontraktu
FROM Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta = Imprezy.IDKlienta
GROUP BY Klienci.NazwiskoKlienta, Klienci.ImieKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta;


CREATE VIEW R13_laczna_wartosc_kontraktow
AS
SELECT CE.PersonaliaKlienta,
   CE.PelnyAdresKlienta,
   MAX(CE.DzienRozpoczecia) AS OstatniaData,
   SUM(CE.WartoscKontraktu) AS LacznaWartoscKontraktu
FROM
    (SELECT CONCAT(Klienci.NazwiskoKlienta, ', ',
   Klienci.ImieKlienta) AS PersonaliaKlienta,
      CONCAT(Klienci.AdresKlienta, ', ', 
      Klienci.MiastoKlienta, ', ', 
      Klienci.StanZamKlienta, ' ', 
      Klienci.KodPocztowyKlienta) AS PelnyAdresKlienta,
      Imprezy.DzienRozpoczecia,
      Imprezy.WartoscKontraktu
   FROM Klienci
   INNER JOIN Imprezy
   ON Klienci.IDKlienta =
      Imprezy.IDKlienta
   WHERE Klienci.StanZamKlienta ='WA')
AS CE
GROUP BY CE.PersonaliaKlienta,
   CE.PelnyAdresKlienta;


CREATE VIEW R13_wykonawcy_i_wartosci_kontraktow
AS 
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Imprezy.WartoscKontraktu
FROM Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
ORDER BY Wykonawcy.NazwaScenicznaWykonawcy;


CREATE VIEW R13_wynagrodzenie_czlonkow_zespolu
AS 
SELECT Wykonawcy.IDWykonawcy, Czlonkowie.ImieCzlonka, Czlonkowie.NazwiskoCzlonka, (Sum(Imprezy.WartoscKontraktu)/(Select Count(*) FROM Czlonkowie_zespolu AS EM2 WHERE EM2.Status <> 3
AND EM2.IDWykonawcy = Wykonawcy.IDWykonawcy)) AS WynagrCzlZes
FROM ((Czlonkowie
INNER JOIN Czlonkowie_zespolu
ON Czlonkowie.IDCzlonka = Czlonkowie_zespolu.IDCzlonka)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy = Czlonkowie_zespolu.IDWykonawcy)
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
WHERE Czlonkowie_zespolu.Status <> 3
GROUP BY Wykonawcy.IDWykonawcy, Czlonkowie.ImieCzlonka, Czlonkowie.NazwiskoCzlonka
ORDER BY Czlonkowie.NazwiskoCzlonka;


CREATE VIEW R14_kontrakty_agentow_duze_prowizje
AS 
SELECT Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Sum(Imprezy.WartoscKontraktu) AS SumaWartosciKontraktow, (Sum(WartoscKontraktu) * Premia) AS Prowizja
FROM Agenci
INNER JOIN Imprezy
ON Agenci.IDAgenta = Imprezy.IDAgenta
GROUP BY Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.Premia
HAVING Prowizja > 1000;


CREATE VIEW R14_agenci_z_umowami_za_ponad_3000_w_12_2017
AS 
SELECT Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Sum(Imprezy.WartoscKontraktu) AS LacznaWartKontr
FROM Agenci
INNER JOIN Imprezy
ON Agenci.IDAgenta = Imprezy.IDAgenta
WHERE Imprezy.DzienRozpoczecia Between CAST('2017-12-01' AS DATE)
AND CAST('2017-12-31' AS DATE)
GROUP BY Agenci.ImieAgenta, Agenci.NazwiskoAgenta
HAVING Sum(Imprezy.WartoscKontraktu) > 3000;


CREATE VIEW R14_wykonawcy_z_ponad_2_rownoleglymi_wystepami
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy IN
(SELECT E1.IDWykonawcy
FROM Imprezy AS E1
INNER JOIN Imprezy AS E2
ON E1.IDWykonawcy = E2.IDWykonawcy
WHERE E1.NumerImprezy <> E2.NumerImprezy
AND E1.DzienRozpoczecia <= E2.DzienZakonczenia
AND E1.DzienZakonczenia >= E2.DzienRozpoczecia
GROUP BY E1.IDWykonawcy
HAVING COUNT(*) > 2);


CREATE VIEW R14_zespoly_jazzowe_liczace_wiecej_niz_3_czlonkow
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Count(Czlonkowie_zespolu.IDWykonawcy) AS LiczbaCzlonkow
FROM ((Wykonawcy INNER JOIN Czlonkowie_zespolu 
ON Wykonawcy.IDWykonawcy=Czlonkowie_zespolu.IDWykonawcy) 
INNER JOIN Style_wykonawcow 
ON Wykonawcy.IDWykonawcy=Style_wykonawcow.IDWykonawcy) 
INNER JOIN Style_muzyczne 
ON Style_muzyczne.IDStylu=Style_wykonawcow.IDStylu
WHERE Style_muzyczne.NazwaStylu='Jazz'
GROUP BY Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
HAVING Count(Czlonkowie_zespolu.IDWykonawcy)>3;


CREATE VIEW R18_agenci_bez_kontraktow_na_country_countryrock
AS 
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta
FROM Agenci
WHERE Agenci.IDAgenta NOT IN 
(SELECT Imprezy.IDAgenta 
FROM ((Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) 
INNER JOIN Style_wykonawcow 
ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy) 
INNER JOIN Style_muzyczne 
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu IN ('Country', 'Country Rock'));


CREATE VIEW R18_klienci_bez_rezerwacji_NOT_IN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT Imprezy.IDKlienta FROM Imprezy);


CREATE VIEW R18_klienci_ktorzy_nie_rezerwowali_wystepu_Topazz_i_MD
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy = 'Topazz')
AND IDKlienta NOT IN
(SELECT IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy = 'Modern Dance');


CREATE VIEW R18_klienci_Peacock_Coie_Jazz_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS  
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Carol Peacock Trio'
AND Imprezy.IDKlienta = Klienci.IDKlienta)
AND EXISTS 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Caroline Coie Cuartet'
AND Imprezy.IDKlienta = Klienci.IDKlienta)
AND EXISTS 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Jazz Persuasion'
AND Imprezy.IDKlienta = Klienci.IDKlienta);


CREATE VIEW R18_klienci_Peacock_Coie_Jazz_IN_DOBRZE
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Carol Peacock Trio')
AND Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Caroline Coie Cuartet')
AND Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Jazz Persuasion');


CREATE VIEW R18_klienci_Peacock_Coie_Jazz_IN_ZLE
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Klienci.IDKlienta 
FROM (Klienci
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta) 
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy  
WHERE Wykonawcy.NazwaScenicznaWykonawcy IN 
('Carol Peacock Trio', 'Caroline Coie Cuartet', 'Jazz Persuasion'));


CREATE VIEW R18_klienci_Peacock_Coie_Jazz_INNERJOIN
AS 
SELECT DISTINCT CPT.IDKlienta, CPT.ImieKlienta, CPT.NazwiskoKlienta
FROM ((SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta 
FROM (Klienci INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Carol Peacock Trio')  AS CPT
INNER JOIN (SELECT Klienci.IDKlienta 
FROM (Klienci INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Caroline Coie Cuartet')  AS CCC
ON CPT.IDKlienta=CCC.IDKlienta)
INNER JOIN (SELECT Klienci.IDKlienta 
FROM (Klienci INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Jazz Persuasion')  AS JP
ON CCC.IDKlienta=JP.IDKlienta;


CREATE VIEW R18_wykonawcy_wystepujacy_dla_Berga_I_Hallmark_EXISTS
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE EXISTS 
(SELECT * FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Berg'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) 
AND EXISTS 
(SELECT * 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Hallmark'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy);


CREATE VIEW R18_wykonawcy_doskonale_pasujacy_do_gustu_klienta
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Count(Gusty_muzyczne.IDStylu) AS LiczbaStylow
FROM ((Klienci
INNER JOIN Gusty_muzyczne
ON Klienci.IDKlienta=Gusty_muzyczne.IDKlienta)
INNER JOIN Style_wykonawcow
ON Gusty_muzyczne.IDStylu=Style_wykonawcow.IDStylu)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy=Style_wykonawcow.IDWykonawcy
GROUP BY Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
HAVING Count(Gusty_muzyczne.IDStylu) =  (SELECT Count(*)  FROM Gusty_muzyczne  WHERE Gusty_muzyczne.IDKlienta = Klienci.IDKlienta);


CREATE VIEW R18_wyk_dla_klientow_Hartwig_McCrae_i_Rosales_EXISTS
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE EXISTS 
(SELECT * FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Hartwig'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) 
AND EXISTS 
(SELECT * 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='McCrae'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy)
AND EXISTS 
(SELECT * 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Rosales'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy);


CREATE VIEW R18_wykonawcy_jazz_rhythmblues_salsa_HAVING
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM (Wykonawcy
INNER JOIN Style_wykonawcow
ON Wykonawcy.IDWykonawcy=Style_wykonawcow.IDWykonawcy)
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu=Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu In ('Jazz','Rhythm and Blues','Salsa')
GROUP BY Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
HAVING Count(*)=3;


CREATE VIEW R18_wykonawcy_jazz_rhythmblues_salsa_IN
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy IN 
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu = 'Jazz')
AND Wykonawcy.IDWykonawcy IN  
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu = 'Rhythm and Blues')
AND Wykonawcy.IDWykonawcy IN
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu = 'Salsa');


CREATE VIEW R18_wykonawcy_jazz_rhythmblues_salsa_IN_ZLE
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy IN 
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu IN ('Jazz', 'Rhythm and Blues', 'Salsa'));


CREATE VIEW R18_wykonawcy_nigdy_nie_zamawiani_NOT_IN
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy NOT IN
(SELECT Imprezy.IDWykonawcy FROM Imprezy);


CREATE VIEW R18_wykonawcy_nie_wystepujacy_90_dni_przed_1maja2018
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy NOT IN
(SELECT Imprezy.IDWykonawcy 
FROM Imprezy 
WHERE Imprezy.DzienRozpoczecia > Date_Add(CAST('2018-05-01' AS Date), INTERVAL -90 Day));


CREATE VIEW R19_gusty_klientow_i_oldies
AS
SELECT        Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
                         (CASE NazwaStylu 
                          WHEN 'Muzyka lat 50.' THEN 'Oldies' 
                          WHEN 'Muzyka lat 60.' THEN 'Oldies' 
                          WHEN 'Muzyka lat 70.' THEN 'Oldies' 
                          WHEN 'Muzyka lat 80.' THEN 'Oldies' ELSE NazwaStylu
                          END) AS StylKlienta
FROM            Klienci INNER JOIN Gusty_muzyczne 
                          ON Klienci.IDKlienta = Gusty_muzyczne.IDKlienta 
                          INNER JOIN Style_muzyczne 
                          ON Gusty_muzyczne.IDStylu = Style_muzyczne.IDStylu;


CREATE VIEW R19_klienci_lubiacy_jazz_ale_nie_standardy
AS
SELECT        IDKlienta, ImieKlienta, NazwiskoKlienta
FROM            Klienci
WHERE        (1 = (CASE WHEN IDKlienta NOT IN
                             (SELECT        IDKlienta
                               FROM            Gusty_muzyczne INNER JOIN Style_muzyczne 
                                               ON Gusty_muzyczne.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Jazz') 
                   THEN 0 
                   WHEN IDKlienta IN
                             (SELECT        IDKlienta
                               FROM            Gusty_muzyczne INNER JOIN Style_muzyczne 
                                               ON Gusty_muzyczne.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Standardy') 
                   THEN 0 ELSE 1 END));


CREATE VIEW R19_wykonawcy_wystepujacy_na_gwiazdke_2017
AS
SELECT        IDWykonawcy, NazwaScenicznaWykonawcy, 
              (CASE WHEN IDWykonawcy IN
                             (SELECT        IDWykonawcy
                               FROM            Imprezy
                               WHERE        CAST('2017-12-25' AS Date) BETWEEN DzienRozpoczecia AND DzienZakonczenia) 
                    THEN 'Zarezerwowany' ELSE 'Bez rezerwacji' END) AS RezerwSwieta2017
FROM            Wykonawcy;


CREATE VIEW R19_wykonawcy_grajacy_jazz_ale_nie_wspolczesna
AS
SELECT        IDWykonawcy, NazwaScenicznaWykonawcy
FROM            Wykonawcy
WHERE        (1 = (CASE WHEN IDWykonawcy NOT IN
                             (SELECT        IDWykonawcy
                               FROM            Style_wykonawcow INNER JOIN
                                                         Style_muzyczne ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Jazz') 
                   THEN 0 
                   WHEN IDWykonawcy IN
                             (SELECT        IDWykonawcy
                               FROM            Style_wykonawcow INNER JOIN
                                                         Style_muzyczne ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Współczesna') 
                   THEN 0 ELSE 1 END));


CREATE VIEW R20_agenci_wykonawcy_bez_rezerwacji_1lut2018
AS
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.AdresAgenta, Agenci.MiastoAgenta, Agenci.StanZamAgenta, Agenci.KodPocztowyAgenta, 
            Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Wykonawcy.TelefonWykonawcy, Style_muzyczne.NazwaStylu
FROM Agenci, (Wykonawcy INNER JOIN Style_wykonawcow 
                          ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy) 
                         INNER JOIN Style_muzyczne 
                         ON Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu
WHERE Wykonawcy.IDWykonawcy Not In 
    (SELECT Imprezy.IDWykonawcy 
     FROM Imprezy 
     WHERE Imprezy.DzienZakonczenia >= CAST('2018-02-01' AS Date)
         AND Imprezy.DzienRozpoczecia <= CAST('2018-02-01' AS Date))
ORDER BY Agenci.IDAgenta, Wykonawcy.IDWykonawcy;


CREATE VIEW R20_wszystkie_dni_grudnia_i_wystepy
AS 
SELECT ztblDni.PoleDaty, BD.IDWykonawcy, BD.NazwaScenicznaWykonawcy
FROM ztblDni LEFT JOIN 
(SELECT ztblDni.PoleDaty, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy 
FROM ztblDni, Wykonawcy INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy 
WHERE ztblDni.PoleDaty>=Imprezy.DzienRozpoczecia 
AND ztblDni.PoleDaty<=Imprezy.DzienZakonczenia 
AND ztblDni.PoleDaty Between CAST('2017-12-01' AS date) AND CAST('2017-12-31' AS date))  AS BD
ON ztblDni.PoleDaty=BD.PoleDaty
WHERE ztblDni.PoleDaty Between CAST('2017-12-01' AS date) And CAST('2017-12-31' AS date);


CREATE VIEW R20_wszystkie_imprezy_sty2018_podzial_na_tygodnie
AS 
SELECT ztblTygodnie.PoczatekTygodnia, ztblTygodnie.KoniecTygodnia, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, 
  Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia
FROM ztblTygodnie, (Klienci INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
WHERE (ztblTygodnie.PoczatekTygodnia <= CAST('2018-01-31' AS date))
AND (ztblTygodnie.KoniecTygodnia >= CAST('2018-01-01' AS date))
AND (Imprezy.DzienRozpoczecia <= ztblTygodnie.KoniecTygodnia)
AND (Imprezy.DzienZakonczenia >= ztblTygodnie.PoczatekTygodnia);


CREATE VIEW R20_etykiety_do_wysylki_z_pominieciem_4
AS 
SELECT ' ' As ImieKlienta, ' ' As NazwiskoKlienta, ' ' As AdresKlienta, ' ' As MiastoKlienta, ' ' As StanZamKlienta, ' ' As KodPocztowyKlienta 
FROM ztblPomijanieEtykiet
WHERE ztblPomijanieEtykiet.LicznikEtykiet <= 4
UNION ALL SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta
FROM Klienci 
ORDER BY KodPocztowyKlienta, NazwiskoKlienta;


CREATE VIEW R20_ranking_gustow_muzycznych_klientow
AS 
SELECT Style_muzyczne.IDStylu, Style_muzyczne.NazwaStylu, COUNT(RankingGustow.PierwszyStyl) AS PierwszaPreferencja, 
  COUNT(RankingGustow.DrugiStyl) AS DrugaPreferencja, COUNT(RankingGustow.TrzeciStyl) AS TrzeciaPreferencja
FROM Style_muzyczne, (SELECT (CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 1 
                              THEN Gusty_muzyczne.IDStylu ELSE Null END) As PierwszyStyl, 
                              (CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 2
                              THEN Gusty_muzyczne.IDStylu ELSE Null END) As DrugiStyl, 
                              (CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 3 
                              THEN Gusty_muzyczne.IDStylu ELSE Null END) As TrzeciStyl
			FROM Gusty_muzyczne)  AS RankingGustow
WHERE Style_muzyczne.IDStylu = RankingGustow.PierwszyStyl 
OR Style_muzyczne.IDStylu = RankingGustow.DrugiStyl
OR Style_muzyczne.IDStylu = RankingGustow.TrzeciStyl
GROUP BY IDStylu, NazwaStylu
HAVING COUNT(PierwszyStyl) > 0 
OR     COUNT(DrugiStyl) > 0 
OR     COUNT(TrzeciStyl) > 0
ORDER BY PierwszaPreferencja DESC, DrugaPreferencja DESC, TrzeciaPreferencja DESC, IDStylu;


CREATE VIEW R20_klienci_o_gustach_pasujacych_do_stylow_wykonawcow
AS 
SELECT IDKlienta, ImieKlienta, NazwiskoKlienta, IDWykonawcy, NazwaScenicznaWykonawcy, 
   PierwszaPreferencja, DrugaPreferencja, TrzeciaPreferencja, PierwszyWplyw, DrugiWplyw, TrzeciWplyw
FROM (SELECT 		Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
		MAX((CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 1  
                     THEN Gusty_muzyczne.IDStylu ELSE Null END)) AS PierwszaPreferencja,
		MAX((CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 2  
                     THEN Gusty_muzyczne.IDStylu ELSE Null END)) AS DrugaPreferencja,
		MAX((CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 3  
                     THEN Gusty_muzyczne.IDStylu ELSE Null END)) AS TrzeciaPreferencja
	FROM Gusty_muzyczne
        INNER JOIN Klienci
        ON Gusty_muzyczne.IDKlienta = Klienci.IDKlienta 
GROUP BY Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta)  AS RankingGustow, 
(SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, 
		MAX((CASE WHEN Style_wykonawcow.WplywStylu = 1 
                     THEN Style_wykonawcow.IDStylu ELSE Null END)) AS PierwszyWplyw, 
		MAX((CASE WHEN Style_wykonawcow.WplywStylu = 2 
                     THEN Style_wykonawcow.IDStylu ELSE Null END)) AS DrugiWplyw, 
		MAX((CASE WHEN Style_wykonawcow.WplywStylu = 3 
                     THEN Style_wykonawcow.IDStylu ELSE Null END)) As TrzeciWplyw 
	FROM Style_wykonawcow
        INNER JOIN Wykonawcy 
        ON Style_wykonawcow.IDWykonawcy = Wykonawcy.IDWykonawcy 
GROUP BY Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy)  AS RankedStrengths
WHERE ((PierwszaPreferencja = PierwszyWplyw)
AND (DrugaPreferencja = DrugiWplyw))
OR ((DrugaPreferencja =PierwszyWplyw)
AND (PierwszaPreferencja = DrugiWplyw));


CREATE VIEW R20_laczne_kwoty_rezerwacji_wg_miesiaca
AS 
SELECT Wykonawcy.NazwaScenicznaWykonawcy, SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Styczen) AS Styczen, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Luty) AS Luty, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Marzec) AS Marzec, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Kwiecien) AS Kwiecien, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Maj) AS Maj, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Czerwiec) AS Czerwiec, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Lipiec) AS Lipiec, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Sierpien) AS Sierpien, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Wrzesien) AS Wrzesien, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Pazdziernik) AS Pazdziernik, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Listopad) AS Listopad, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Grudzien) AS Grudzien
FROM ztblMiesiace, Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
WHERE Imprezy.DzienRozpoczecia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;


CREATE VIEW R20_ranking_wplywu_stylow_wykonawcow
AS 
SELECT Style_muzyczne.IDStylu, Style_muzyczne.NazwaStylu, COUNT(RankingGustow.PierwszyStyl) AS PierwszyWplyw, 
   COUNT(RankingGustow.DrugiStyl) AS DrugiWplyw, COUNT(RankingGustow.TrzeciStyl) AS TrzeciWplyw
FROM Style_muzyczne, 
(SELECT (CASE WHEN Style_wykonawcow.WplywStylu = 1 
              THEN Style_wykonawcow.IDStylu ELSE Null END) As PierwszyStyl, 
        (CASE WHEN Style_wykonawcow.WplywStylu = 2 
              THEN Style_wykonawcow.IDStylu ELSE Null END) As DrugiStyl, 
        (CASE WHEN Style_wykonawcow.WplywStylu = 3 
              THEN Style_wykonawcow.IDStylu ELSE Null END) As TrzeciStyl
FROM Style_wykonawcow)  AS RankingGustow
WHERE Style_muzyczne.IDStylu = RankingGustow.PierwszyStyl
    OR Style_muzyczne.IDStylu = RankingGustow.DrugiStyl
    OR Style_muzyczne.IDStylu = RankingGustow.TrzeciStyl
GROUP BY IDStylu, NazwaStylu
HAVING COUNT(PierwszyStyl) > 0 
   OR COUNT(DrugiStyl) > 0 
   OR COUNT(TrzeciStyl) > 0
ORDER BY PierwszyWplyw DESC, DrugiWplyw DESC, TrzeciWplyw DESC, IDStylu;


